<?php

namespace App\Models\Parcel;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ParcelItem extends Model 
{

    protected $table = 'parcel_items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('parcel_id', 'package_id');

    public function parcel()
    {
        return $this->belongsTo('App\Models\Parcel');
    }

}